/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.ui.components.gif;

import Krasnodar.rockstarnew.Rockstar;
import Krasnodar.rockstarnew.framework.base.CustomComponent;
import Krasnodar.rockstarnew.framework.base.UIContext;
import Krasnodar.rockstarnew.ui.components.gif.GifDecoder;
import Krasnodar.rockstarnew.utility.colors.Colors;
import Krasnodar.rockstarnew.utility.interfaces.IMinecraft;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import lombok.Generated;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_3298;

public class FavoriteGif
extends CustomComponent
implements IMinecraft {
    private final int frameCount;
    private int currentFrame = 0;
    private long lastFrameTime = 0L;
    private final GifDecoder gifDecoder = new GifDecoder();
    private final HashMap<Integer, Integer> frameDurations = new HashMap();
    private class_1043 dynamicTexture;
    private final class_2960 dynamicTextureId;
    private float alpha = 1.0f;
    private final class_1011 sharedImage;
    private boolean frozen = true;
    private boolean playOnce = false;
    private int playStartFrame = 0;
    private boolean hasPlayedOnce = false;

    public FavoriteGif(class_2960 gifIdentifier, float x, float y, float width, float height) {
        super(x, y, width, height);
        try {
            class_3298 gifResource = mc.method_1478().getResourceOrThrow(gifIdentifier);
            this.gifDecoder.read(gifResource.method_14482());
        }
        catch (Exception var12) {
            throw new RuntimeException("Failed to load GIF: " + var12.getMessage(), var12);
        }
        this.frameCount = this.gifDecoder.getFrameCount();
        for (int i = 0; i < this.frameCount; ++i) {
            this.frameDurations.put(i, this.gifDecoder.getDelay(i));
        }
        BufferedImage firstFrame = this.gifDecoder.getFrame(0);
        if (firstFrame == null) {
            throw new RuntimeException("Failed to load first frame from GIF");
        }
        int imgWidth = firstFrame.getWidth();
        int imgHeight = firstFrame.getHeight();
        if (imgWidth <= 0 || imgHeight <= 0) {
            throw new RuntimeException("Invalid GIF dimensions: " + imgWidth + "x" + imgHeight);
        }
        this.sharedImage = new class_1011(class_1011.class_1012.field_4997, imgWidth, imgHeight, false);
        for (int y1 = 0; y1 < imgHeight; ++y1) {
            for (int x1 = 0; x1 < imgWidth; ++x1) {
                try {
                    int argb = firstFrame.getRGB(x1, y1);
                    this.sharedImage.method_61941(x1, y1, argb);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        this.dynamicTexture = new class_1043(this.sharedImage);
        this.dynamicTextureId = Rockstar.id("favorite_gif_texture_" + gifIdentifier.method_12832().hashCode());
        mc.method_1531().method_4616(this.dynamicTextureId, (class_1044)this.dynamicTexture);
        this.dynamicTexture.method_4524();
    }

    private void updateFrame(int frameIndex) {
        if (this.sharedImage == null || this.sharedImage.method_4307() <= 0) {
            return;
        }
        BufferedImage frame = this.gifDecoder.getFrame(frameIndex);
        if (frame == null) {
            return;
        }
        int maxWidth = Math.min(frame.getWidth(), this.sharedImage.method_4307());
        int maxHeight = Math.min(frame.getHeight(), this.sharedImage.method_4323());
        for (int y = 0; y < maxHeight; ++y) {
            for (int x = 0; x < maxWidth; ++x) {
                try {
                    int argb = frame.getRGB(x, y);
                    this.sharedImage.method_61941(x, y, argb);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (this.dynamicTexture != null) {
            this.dynamicTexture.method_4524();
        }
    }

    @Override
    public void update(UIContext context) {
        if (this.frozen) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastFrameTime > (long)this.frameDurations.get(this.currentFrame).intValue()) {
            this.lastFrameTime = currentTime;
            if (this.playOnce) {
                ++this.currentFrame;
                if (this.currentFrame >= this.frameCount) {
                    this.currentFrame = 0;
                    this.frozen = true;
                    this.playOnce = false;
                    this.hasPlayedOnce = true;
                }
            } else {
                this.currentFrame = (this.currentFrame + 1) % this.frameCount;
            }
            this.updateFrame(this.currentFrame);
        }
    }

    @Override
    public void renderComponent(UIContext context) {
        context.drawTexture(this.dynamicTextureId, this.x, this.y, this.width, this.height, Colors.WHITE.mulAlpha(this.alpha));
    }

    public void playOnce() {
        if (!this.frozen) {
            return;
        }
        if (this.sharedImage == null || this.dynamicTexture == null) {
            return;
        }
        this.frozen = false;
        this.playOnce = true;
        this.currentFrame = 0;
        this.lastFrameTime = System.currentTimeMillis();
        this.updateFrame(0);
    }

    public void freeze() {
        this.frozen = true;
        this.playOnce = false;
        this.currentFrame = 0;
        if (this.sharedImage != null && this.dynamicTexture != null) {
            this.updateFrame(0);
        }
    }

    public void setFavoriteState(boolean isFavorite) {
        if (isFavorite) {
            if (this.frozen) {
                this.playOnce();
            }
        } else {
            this.freeze();
        }
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public boolean hasPlayedOnce() {
        return this.hasPlayedOnce;
    }

    public void dispose() {
        if (this.dynamicTexture != null) {
            mc.method_1531().method_4615(this.dynamicTextureId);
            this.dynamicTexture.close();
            this.dynamicTexture = null;
        }
    }

    @Generated
    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    @Override
    public void setX(float x) {
        this.x = x;
    }

    @Override
    public void setY(float y) {
        this.y = y;
    }
}

